\name{resect90_lung_mortality_score}
\alias{resect90_lung_mortality_score}
\title{
RESECT-90 Score for Lung Resection Mortality
}
\description{
Calculates the RESECT-90 score to estimate the 90-day risk of mortality in patients undergoing lung resection (e.g., lobectomy, pneumonectomy). The model is a multivariable logistic regression derived from a large UK cohort (Taylor et al., 2021). It incorporates patient demographics, comorbidities, and surgical factors.
}
\usage{
resect90_lung_mortality_score(age, sex, ecog_ps, dlco_percent, bmi, creatinine,
                              anemia, arrhythmia, right_sided_resection,
                              thoracotomy_approach, malignant_diagnosis,
                              num_resected_segments, creatinine_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. "Male" or "Female". (Male sex is associated with higher risk).
}
  \item{ecog_ps}{
Numeric. Eastern Cooperative Oncology Group (ECOG) performance status (0-4).
}
  \item{dlco_percent}{
Numeric. Percentage predicted diffusion capacity of the lung for carbon monoxide (DLCO).
}
  \item{bmi}{
Numeric. Body Mass Index in kg/m^2. (Higher BMI is associated with lower risk in this model).
}
  \item{creatinine}{
Numeric. Serum creatinine level.
}
  \item{anemia}{
Numeric (0 or 1). Presence of preoperative anemia. (1 = Yes).
}
  \item{arrhythmia}{
Numeric (0 or 1). History of preoperative arrhythmia (e.g., Atrial Fibrillation). (1 = Yes).
}
  \item{right_sided_resection}{
Numeric (0 or 1). Is the surgery a right-sided resection? (1 = Yes).
}
  \item{thoracotomy_approach}{
Numeric (0 or 1). Is the surgery performed via open thoracotomy (vs VATS/Robotic)? (1 = Yes).
}
  \item{malignant_diagnosis}{
Numeric (0 or 1). Is the resection for a malignant diagnosis? (1 = Yes).
}
  \item{num_resected_segments}{
Numeric. Number of bronchopulmonary segments resected (e.g., Lobectomy ~3-5, Pneumonectomy ~10).
}
  \item{creatinine_units}{
String. Units for creatinine. "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{RESECT90_Score_Percent}{The estimated percentage probability of death within 90 days of surgery.}
\item{Interpretation}{Brief context for the result.}
}
\references{
Taylor M, et al. Development and internal validation of a clinical prediction model for 90-day mortality after lung resection: the RESECT-90 score. Interact Cardiovasc Thorac Surg. 2021.
}
\examples{
resect90_lung_mortality_score(
  age = 70,
  sex = "male",
  ecog_ps = 1,
  dlco_percent = 60,
  bmi = 25,
  creatinine = 1.0,
  anemia = 0,
  arrhythmia = 0,
  right_sided_resection = 1,
  thoracotomy_approach = 1,
  malignant_diagnosis = 1,
  num_resected_segments = 3
)
}
