\name{rochester_criteria_febrile_infant}
\alias{rochester_criteria_febrile_infant}
\title{
Rochester Criteria for Febrile Infants
}
\description{
Calculates the Rochester Criteria to identify febrile infants (typically < 60 days old) at low risk for serious bacterial infection (SBI). Meeting all criteria suggests a low risk, potentially allowing for outpatient management without lumbar puncture (though clinical practice varies).
}
\usage{
rochester_criteria_febrile_infant(well_appearing, no_skeletal_soft_tissue_infection,
                                  term_infant, no_unexplained_hyperbilirubinemia,
                                  no_previous_antimicrobials, no_prior_hospitalization,
                                  no_chronic_illness, wbc_count, band_count_percent,
                                  urinalysis_wbc_hpf, stool_wbc_hpf = NULL,
                                  diarrhea_present = 0)
}
\arguments{
  \item{well_appearing}{
Numeric (0 or 1). Infant generally well-appearing? (1 = Yes).
}
  \item{no_skeletal_soft_tissue_infection}{
Numeric (0 or 1). No evidence of ear, soft tissue, or skeletal infection? (1 = Yes).
}
  \item{term_infant}{
Numeric (0 or 1). Born at term (>= 37 weeks)? (1 = Yes).
}
  \item{no_unexplained_hyperbilirubinemia}{
Numeric (0 or 1). No unexplained hyperbilirubinemia? (1 = Yes).
}
  \item{no_previous_antimicrobials}{
Numeric (0 or 1). No previous antimicrobial therapy (perinatal or postnatal)? (1 = Yes).
}
  \item{no_prior_hospitalization}{
Numeric (0 or 1). No prior hospitalizations (excluding birth)? (1 = Yes).
}
  \item{no_chronic_illness}{
Numeric (0 or 1). No chronic or underlying illness? (1 = Yes).
}
  \item{wbc_count}{
Numeric. Peripheral WBC count (cells/mm^3). (Low risk: 5,000 - 15,000).
}
  \item{band_count_percent}{
Numeric. Band neutrophils percentage. (Low risk: Absolute band count < 1,500/mm^3).
}
  \item{urinalysis_wbc_hpf}{
Numeric. Urinalysis WBC per high-power field. (Low risk: < 10).
}
  \item{stool_wbc_hpf}{
Numeric (Optional). Stool WBC per high-power field. Required if diarrhea is present. (Low risk: < 5).
}
  \item{diarrhea_present}{
Numeric (0 or 1). Is diarrhea present? (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Classification}{"Low Risk" or "High Risk".}
\item{Inputs}{Breakdown of whether History, Exam, and Lab criteria were met.}
}
\references{
Jaskiewicz JA, McCarthy CA, Richardson AC, et al. Febrile infants at low risk for serious bacterial infection--an appraisal of the Rochester criteria and implications for management. Febrile Infant Collaborative Study Group. Pediatrics. 1994;94(3):390-396.
}
\examples{

# Example 1: Low Risk
# Well appearing, Term, No history issues, WBC 10k, Bands 5%, UA 2 WBC
rochester_criteria_febrile_infant(1, 1, 1, 1, 1, 1, 1, 10000, 5, 2, NULL, 0)

# Example 2: High Risk
# Preterm (0), otherwise normal
rochester_criteria_febrile_infant(1, 1, 0, 1, 1, 1, 1, 10000, 5, 2, NULL, 0)
}
