\name{rome_iv_functional_chest_pain}
\alias{rome_iv_functional_chest_pain}
\title{
Rome IV Diagnostic Criteria for Functional Chest Pain
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Chest Pain of presumed esophageal origin. Diagnosis requires recurrent retrosternal chest pain (not heartburn) that is not explained by organic esophageal disease (e.g., structural, motility, or reflux disease). Symptoms must be chronic (onset >= 6 months, active >= 3 months).
}
\usage{
rome_iv_functional_chest_pain(retrosternal_pain, other_esophageal_symptoms,
                              normal_egd, normal_esophageal_motility,
                              esophageal_reflux_excluded, symptom_onset_ge_6_months,
                              symptoms_active_last_3_months)
}
\arguments{
  \item{retrosternal_pain}{
Numeric (0 or 1). Presence of retrosternal pain or discomfort. (1 = Yes).
}
  \item{other_esophageal_symptoms}{
Numeric (0 or 1). Presence of associated esophageal symptoms (e.g., heartburn, dysphagia). (1 = Yes). Note: The diagnosis requires the *absence* of these secondary symptoms.
}
  \item{normal_egd}{
Numeric (0 or 1). Normal Esophagogastroduodenoscopy (EGD) (ruling out structural/mucosal lesions like esophagitis, ulcers). (1 = Yes).
}
  \item{normal_esophageal_motility}{
Numeric (0 or 1). Normal esophageal motility (ruling out major motor disorders like achalasia, spasm). (1 = Yes).
}
  \item{esophageal_reflux_excluded}{
Numeric (0 or 1). Absence of evidence that gastroesophageal reflux (GERD) is the cause of the symptom (e.g., negative pH monitoring or symptom relief with PPIs). (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Chest Pain" or "Criteria Not Met".}
}
\references{
Vakil N, van Zanten SV, Kahrilas P, et al. The Montreal definition and classification of gastroesophageal reflux disease: a global evidence-based consensus. Am J Gastroenterol. 2006;101(8):1900-1920.
Aben-Fawaz H, Kahrilas PJ, Chen J. Esophageal disorders. Gastroenterology. 2016;150:1367-1379. doi:10.1053/j.gastro.2016.02.002
}
\examples{

# Example 1: Diagnosis Met
# Retrosternal pain (1), No other Sx (0), Normal EGD (1),
#Normal Motility (1), Reflux excluded (1), Chronic duration
rome_iv_functional_chest_pain(1, 0, 1, 1, 1, 1, 1)

# Example 2: Not Met (Has heartburn)
# Retrosternal pain (1), Has heartburn (1), Normal EGD (1),
#Normal Motility (1), Reflux excluded (1), Chronic duration
rome_iv_functional_chest_pain(1, 1, 1, 1, 1, 1, 1)
}
