\name{rome_iv_ibs_criteria}
\alias{rome_iv_ibs_criteria}
\title{
Rome IV Diagnostic Criteria for Irritable Bowel Syndrome (IBS)
}
\description{
Evaluates the **Rome IV criteria** for diagnosing Irritable Bowel Syndrome (IBS) in adults. Diagnosis requires recurrent abdominal pain on average at least **1 day per week** in the last 3 months, associated with two or more of the following: 1) related to defecation, 2) associated with a change in stool frequency, and 3) associated with a change in stool form/appearance

[Image of bristol stool scale chart]
. Symptoms must have started at least 6 months ago.
}
\usage{
rome_iv_ibs_criteria(pain_frequency_days_month, related_to_defecation,
                     change_stool_frequency, change_stool_form,
                     organic_causes_excluded)
}
\arguments{
  \item{pain_frequency_days_month}{
Numeric. Abdominal pain frequency in **days per month** (must be >= 4 days/month or approximately 1 day/week).
}
  \item{related_to_defecation}{
Numeric (0 or 1). Is the pain **related to defecation**? (1 = Yes).
}
  \item{change_stool_frequency}{
Numeric (0 or 1). Is the pain associated with a **change in stool frequency**? (1 = Yes).
}
  \item{change_stool_form}{
Numeric (0 or 1). Is the pain associated with a **change in stool form** (appearance)? (1 = Yes).
}
  \item{organic_causes_excluded}{
Numeric (0 or 1). Have **organic, systemic, or metabolic diseases** been excluded? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Meets Criteria for Irritable Bowel Syndrome (IBS)" or "Criteria Not Met".}
\item{IBS_Features_Count}{The number of positive associated features (max 3).}
}
\references{
Lacy BE, Mearin F, Chang L, et al. Bowel Disorders. Gastroenterology. 2016;150:1393-1407. doi:10.1053/j.gastro.2016.02.031
}
\examples{

# Example 1: Diagnosis Met
# Pain 5 days/mo, related to defecation, change in form. Organic disease ruled out.
# Result: Meets Criteria (2 of 3 features)
rome_iv_ibs_criteria(5, 1, 0, 1, 1)

# Example 2: Not Met (Insufficient frequency)
# Pain 1 day/mo, related to defecation, change in form.
rome_iv_ibs_criteria(1, 1, 0, 1, 1)
}
