\name{rome_iv_rumination_syndrome}
\alias{rome_iv_rumination_syndrome}
\title{
Rome IV Diagnostic Criteria for Rumination Syndrome
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Rumination Syndrome** (in adults and adolescents). Diagnosis requires repeated regurgitation and re-chewing or expulsion of food starting soon after ingestion, **not** during sleep, **not** preceded by retching, and **not** explained by another medical condition or eating disorder. Symptoms must have started at least 6 months prior and been active for the last 3 months.
}
\usage{
rome_iv_rumination_syndrome(symptom_duration_months, repeated_regurgitation,
                            starts_soon_after_meal, does_not_occur_during_sleep,
                            no_retching_preceding, not_explained_by_medical_condition)
}
\arguments{
  \item{symptom_duration_months}{
Numeric. Duration of symptoms in months (Must be **>= 2 months**).
}
  \item{repeated_regurgitation}{
Numeric (0 or 1). Presence of repeated regurgitation and re-chewing or expulsion of food. (1 = Yes).
}
  \item{starts_soon_after_meal}{
Numeric (0 or 1). Does the regurgitation begin **soon after ingestion** of a meal? (1 = Yes).
}
  \item{does_not_occur_during_sleep}{
Numeric (0 or 1). Does the regurgitation **NOT occur during sleep**? (1 = Yes, it does not occur during sleep).
}
  \item{no_retching_preceding}{
Numeric (0 or 1). Is the regurgitation **NOT preceded by retching**? (1 = Yes, no preceding retching).
}
  \item{not_explained_by_medical_condition}{
Numeric (0 or 1). Are symptoms **NOT** better explained by another medical condition (e.g., GERD, eosinophilic esophagitis) or eating disorder? (1 = Yes, not explained by others).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Rumination Syndrome" or "Criteria Not Met".}
}
\references{
Stanghellini V, Chan FK, Hasler WL, et al. Gastroduodenal Disorders. Gastroenterology. 2016;150:1380-1392. doi:10.1053/j.gastro.2016.02.011
}
\examples{

# Example 1: Diagnosis Met
# 3 months duration, Regurgitation, After meal, Not sleep, No retching, No other cause
rome_iv_rumination_syndrome(3, 1, 1, 1, 1, 1)

# Example 2: Not Met (Vomiting is preceded by retching)
# 3 months duration, Retching precedes (0 for no_retching)
rome_iv_rumination_syndrome(3, 1, 1, 1, 0, 1)
}
