\name{ruis_score}
\alias{ruis_score}
\title{
Revised Urinary Incontinence Scale (RUIS)
}
\description{
Calculates the Revised Urinary Incontinence Scale (RUIS) score to assess the severity of urinary incontinence. The scale consists of 5 items evaluating leakage related to activity, urgency, other causes, amount, and frequency.
}
\usage{
ruis_score(leakage_activity, leakage_urgency, leakage_no_activity,
           leakage_amount, leakage_frequency)
}
\arguments{
  \item{leakage_activity}{
Numeric (0-3). Q1: How often do you experience urine leakage related to physical activity, coughing, or sneezing?
0: Not at all
1: Slightly
2: Moderately
3: Greatly
}
  \item{leakage_urgency}{
Numeric (0-3). Q2: How often do you experience urine leakage related to the feeling of urgency?
0: Not at all
1: Slightly
2: Moderately
3: Greatly
}
  \item{leakage_no_activity}{
Numeric (0-3). Q3: How often do you experience urine leakage related to neither physical activity nor urgency?
0: Not at all
1: Slightly
2: Moderately
3: Greatly
}
  \item{leakage_amount}{
Numeric (0-3). Q4: How much urine do you lose each time?
0: Drops
1: Small splashes
2: More than splashes
}
  \item{leakage_frequency}{
Numeric (0-4). Q5: How often do you experience urine leakage?
0: Never
1: Once a month or less
2: Two or three times a month
3: Once a week
4: Every day and/or night
}
}
\value{
A list containing:
\item{RUIS_Score}{The calculated total score (Range 0-16).}
\item{Severity_Level}{Classification (Slight 0-3, Moderate 4-8, Severe >=9).}
}
\references{
Sansoni J, Hawthorne G, Marosszeky N, et al. Validation of the Revised Urinary Incontinence Scale (RUIS). Proc Int Continence Soc. 2010.
}
\examples{

# Example 1: Moderate Incontinence
# Activity(2), Urgency(1), Other(0), Amount(1), Frequency(3)
# Score = 2+1+0+1+3 = 7
ruis_score(2, 1, 0, 1, 3)

# Example 2: Severe Incontinence
# Activity(3), Urgency(3), Other(1), Amount(2), Frequency(4)
# Score = 3+3+1+2+4 = 13
ruis_score(3, 3, 1, 2, 4)
}
