\name{saps_ii_score}
\alias{saps_ii_score}
\title{
Simplified Acute Physiology Score II (SAPS II)
}
\description{
Calculates the SAPS II score and predicted hospital mortality for patients admitted to the ICU. The score uses 17 variables: 12 physiological variables, age, type of admission, and three underlying disease variables.
}
\usage{
saps_ii_score(age, heart_rate, systolic_bp, temperature_c,
              mechanical_ventilation_cpap, pao2, fio2, urine_output_24h_l,
              bun, wbc_count, potassium, sodium, bicarbonate, bilirubin,
              gcs, admission_type, chronic_diseases = NULL,
              bun_units = "mg/dL", bilirubin_units = "mg/dL")
}
\arguments{
  \item{age}{Numeric. Patient age in years.}
  \item{heart_rate}{Numeric. Worst heart rate in the first 24 hours (bpm).}
  \item{systolic_bp}{Numeric. Worst systolic blood pressure in the first 24 hours (mmHg).}
  \item{temperature_c}{Numeric. Worst body temperature in the first 24 hours (Celsius).}
  \item{mechanical_ventilation_cpap}{Numeric (0 or 1). Is the patient on mechanical ventilation or CPAP? (1 = Yes).}
  \item{pao2}{Numeric. PaO2 in mmHg (only used if ventilated).}
  \item{fio2}{Numeric. FiO2 percentage or fraction (e.g., 50 or 0.5) (only used if ventilated).}
  \item{urine_output_24h_l}{Numeric. Urine output in Liters per 24 hours.}
  \item{bun}{Numeric. Blood Urea Nitrogen level.}
  \item{wbc_count}{Numeric. White Blood Cell count (x10^3/mm^3).}
  \item{potassium}{Numeric. Serum Potassium level (mmol/L).}
  \item{sodium}{Numeric. Serum Sodium level (mmol/L).}
  \item{bicarbonate}{Numeric. Serum Bicarbonate level (mEq/L).}
  \item{bilirubin}{Numeric. Total Bilirubin level.}
  \item{gcs}{Numeric. Glasgow Coma Scale score (3-15).}
  \item{admission_type}{String. "scheduled_surgical", "medical", or "unscheduled_surgical".}
  \item{chronic_diseases}{Vector of strings. List of comorbidities: "aids", "hematologic_malignancy", "metastatic_cancer".}
  \item{bun_units}{String. "mg/dL" (default) or "mmol/L".}
  \item{bilirubin_units}{String. "mg/dL" (default) or "umol/L".}
}
\value{
A list containing:
\item{SAPS_II_Score}{The calculated SAPS II score.}
\item{Predicted_Hospital_Mortality}{The estimated probability of hospital mortality percentage.}
}
\references{
Le Gall JR, Lemeshow S, Saulnier F. A new Simplified Acute Physiology Score (SAPS II) based on a European/North American multicenter study. JAMA. 1993;270(24):2957-2963. doi:10.1001/jama.1993.03510240069035
}
\examples{
saps_ii_score(
  age = 65, heart_rate = 130, systolic_bp = 90, temperature_c = 39.0,
  mechanical_ventilation_cpap = 1, pao2 = 70, fio2 = 50, urine_output_24h_l = 0.8,
  bun = 35, wbc_count = 18, potassium = 4.0, sodium = 135, bicarbonate = 18,
  bilirubin = 1.0, gcs = 10, admission_type = "medical",
  chronic_diseases = c("metastatic_cancer")
)
}
