\name{score2_diabetes_risk}
\alias{score2_diabetes_risk}
\title{
SCORE2-Diabetes Risk Algorithm
}
\description{
Calculates the 10-year risk of fatal and non-fatal cardiovascular disease (CVD) in patients with type 2 diabetes. This algorithm is an extension of the SCORE2 model, calibrated for four European risk regions, and incorporates diabetes-specific risk factors including HbA1c, eGFR, and duration of diabetes.
}
\usage{
score2_diabetes_risk(sex, age, smoking_status, systolic_bp, total_cholesterol,
                     hdl_cholesterol, hba1c, egfr, age_diabetes_diagnosis,
                     region_risk_level = "low", cholesterol_units = "mmol/L",
                     hba1c_units = "mmol/mol")
}
\arguments{
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{age}{
Numeric. Patient age in years (40-69).
}
  \item{smoking_status}{
Numeric (0 or 1). Current smoker status (1 = Yes).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{total_cholesterol}{
Numeric. Total cholesterol level.
}
  \item{hdl_cholesterol}{
Numeric. HDL cholesterol level.
}
  \item{hba1c}{
Numeric. Glycated hemoglobin level.
}
  \item{egfr}{
Numeric. Estimated Glomerular Filtration Rate in mL/min/1.73m^2.
}
  \item{age_diabetes_diagnosis}{
Numeric. Age at diagnosis of diabetes in years (used to calculate duration).
}
  \item{region_risk_level}{
String. European risk region classification: "low", "moderate", "high", "very_high".
}
  \item{cholesterol_units}{
String. Units for cholesterol inputs: "mmol/L" (default) or "mg/dL".
}
  \item{hba1c_units}{
String. Units for HbA1c input: "mmol/mol" (default) or "per" (DCCT).
}
}
\value{
A list containing:
\item{Calculated_Variables}{Derived values used in the regression model (Non-HDL, Duration, Centered Age).}
\item{Message}{Note regarding the requirement for specific regression coefficients.}
}
\references{
SCORE2-Diabetes Working Group and the ESC Cardiovascular Risk Collaboration. SCORE2-Diabetes: 10-year cardiovascular risk prediction in type 2 diabetes. Eur Heart J. 2023;44(28):2544-2556. doi:10.1093/eurheartj/ehad260
}
\examples{

# Example 1: Moderate Risk Region
# Male, 60yo, Smoker, SBP 140, TC 5.0, HDL 1.0, HbA1c 50 mmol/mol, eGFR 70, Dx age 50
score2_diabetes_risk("male", 60, 1, 140, 5.0, 1.0, 50, 70, 50, "moderate")

# Example 2: High Risk Region (US Units)
# Female, 55yo, Non-smoker, SBP 130, TC 200 mg/dL, HDL 50 mg/dL, HbA1c 7.5per, eGFR 55, Dx age 45

score2_diabetes_risk("female", 55, 0, 130, 200, 50, 7.5, 55, 45, "high", "mg/dL", "per")
}
