\name{smast_g_score}
\alias{smast_g_score}
\title{
Short Michigan Alcoholism Screening Test - Geriatric Version (SMAST-G)
}
\description{
Calculates the SMAST-G score, a 10-item screening tool specifically designed to identify alcohol problems in older adults. A score of 2 or more is generally considered a positive screen indicative of potential alcohol abuse.
}
\usage{
smast_g_score(underestimate_drinking, skip_meals, decrease_shakes, memory_loss,
              drink_to_relax, drink_to_forget_problems, increase_after_loss,
              doctor_concerned, make_rules, drink_when_lonely)
}
\arguments{
  \item{underestimate_drinking}{
Numeric (0 or 1). When talking with others, do you ever underestimate how much you drink? (1 = Yes).
}
  \item{skip_meals}{
Numeric (0 or 1). After a few drinks, have you sometimes not eaten or been able to skip a meal because you didn't feel hungry? (1 = Yes).
}
  \item{decrease_shakes}{
Numeric (0 or 1). Does having a few drinks help decrease your shakiness or tremors? (1 = Yes).
}
  \item{memory_loss}{
Numeric (0 or 1). Does alcohol sometimes make it hard for you to remember parts of the day or night? (1 = Yes).
}
  \item{drink_to_relax}{
Numeric (0 or 1). Do you usually take a drink to relax or calm your nerves? (1 = Yes).
}
  \item{drink_to_forget_problems}{
Numeric (0 or 1). Do you drink to take your mind off your major problems? (1 = Yes).
}
  \item{increase_after_loss}{
Numeric (0 or 1). Have you ever increased your drinking after experiencing a loss in your life? (1 = Yes).
}
  \item{doctor_concerned}{
Numeric (0 or 1). Has a doctor or nurse ever said they were worried or concerned about your drinking? (1 = Yes).
}
  \item{make_rules}{
Numeric (0 or 1). Have you ever made rules to manage your drinking? (1 = Yes).
}
  \item{drink_when_lonely}{
Numeric (0 or 1). When you feel lonely, does having a drink help? (1 = Yes).
}
}
\value{
A list containing:
\item{SMAST_G_Score}{The calculated total score (Range 0-10).}
\item{Result}{Interpretation of the screen (Positive/Negative).}
}
\references{
Blow FC, Brower KJ, Schulenberg JE, et al. The Short Michigan Alcoholism Screening Test - Geriatric Version (SMAST-G): a new elderly-specific screening instrument. Alcohol Clin Exp Res. 1992.
}
\examples{

# Example 1: Positive Screen
# Drinks to relax (1), Doctor concerned (1), Lonely (1)
# Score = 3
smast_g_score(0, 0, 0, 0, 1, 0, 0, 1, 0, 1)

# Example 2: Negative Screen
# No affirmative responses
# Score = 0
smast_g_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
