\name{sodium_correction_hyperglycemia}
\alias{sodium_correction_hyperglycemia}
\title{
Sodium Correction for Hyperglycemia
}
\description{
Calculates the corrected serum sodium level in the presence of hyperglycemia. High blood glucose draws water from the intracellular space into the extracellular space, diluting the serum sodium (translocational hyponatremia). Correcting the sodium concentration helps determine if the patient is truly hyponatremic, eunatremic, or hypernatremic.
}
\usage{
sodium_correction_hyperglycemia(measured_sodium, glucose,
                                glucose_units = "mg/dL", correction_factor = 1.6)
}
\arguments{
  \item{measured_sodium}{
Numeric. The measured serum sodium level in mEq/L or mmol/L.
}
  \item{glucose}{
Numeric. The measured serum glucose level.
}
  \item{glucose_units}{
String. Units for glucose input. Options: "mg/dL" (default) or "mmol/L".
}
  \item{correction_factor}{
Numeric. The factor used to correct sodium for every 100 mg/dL rise in glucose above 100 mg/dL.
Defaults to 1.6 (Katz formula). Another common value is 2.4 (Hillier formula), which may be more accurate for glucose levels > 400 mg/dL.
}
}
\value{
A list containing:
\item{Corrected_Sodium}{The estimated serum sodium concentration if glucose were normal.}
}
\references{
Katz MA. Hyperglycemia-induced hyponatremia--calculation of expected serum sodium depression. N Engl J Med. 1973;289(16):843-844. doi:10.1056/NEJM197310182891607
Hillier TA, Abbott RD, Barrett EJ. Hyponatremia: evaluating the correction factor for hyperglycemia. Am J Med. 1999;106(4):399-403. doi:10.1016/s0002-9343(99)00005-2
}
\examples{

# Example 1: DKA with glucose 600 mg/dL
# Measured Na 128, Glucose 600, using Katz (1.6)
# Correction = 1.6 * ((600-100)/100) = 1.6 * 5 = 8
# Corrected Na = 128 + 8 = 136
sodium_correction_hyperglycemia(128, 600)

# Example 2: Using Hillier factor (2.4) for severe hyperglycemia
# Measured Na 130, Glucose 800
# Correction = 2.4 * 7 = 16.8 -> Corrected ~146.8
sodium_correction_hyperglycemia(130, 800, correction_factor = 2.4)
}
