\name{static_lung_compliance}
\alias{static_lung_compliance}
\title{
Static Lung Compliance (Cstat) Calculator
}
\description{
Calculates the Static Lung Compliance (Cstat) of a mechanically ventilated patient. Static compliance represents the distensibility of the lungs and chest wall when there is no airflow (static conditions). It is calculated using the tidal volume, plateau pressure, and positive end-expiratory pressure (PEEP).
}
\usage{
static_lung_compliance(tidal_volume, plateau_pressure, peep)
}
\arguments{
  \item{tidal_volume}{
Numeric. The exhaled tidal volume in milliliters (mL).
}
  \item{plateau_pressure}{
Numeric. The plateau pressure (Pplat) measured during an inspiratory pause in cmH2O.
}
  \item{peep}{
Numeric. The Positive End-Expiratory Pressure (PEEP) in cmH2O.
}
}
\details{
The formula used is:
\deqn{C_{stat} = \frac{V_T}{P_{plat} - PEEP}}
Where:
\itemize{
  \item \eqn{C_{stat}} is Static Compliance (mL/cmH2O)
  \item \eqn{V_T} is Tidal Volume (mL)
  \item \eqn{P_{plat}} is Plateau Pressure (cmH2O)
  \item \eqn{PEEP} is Positive End-Expiratory Pressure (cmH2O)
}
Normal static compliance in intubated patients is typically 50-80 mL/cmH2O. Values < 30 mL/cmH2O are often seen in severe ARDS.
}
\value{
A list containing:
\item{Static_Compliance_mL_cmH2O}{The calculated static lung compliance.}
\item{Interpretation}{Clinical interpretation of the compliance value.}
}
\references{
Suter PM, Fairley B, Isenberg MD. Optimum end-expiratory airway pressure in patients with acute pulmonary failure. N Engl J Med. 1975;292(6):284-289. doi:10.1056/NEJM197502062920604
}
\examples{

# Example 1: Normal Compliance
# Vt 500 mL, Pplat 15 cmH2O, PEEP 5 cmH2O
# Cstat = 500 / (15 - 5) = 50 mL/cmH2O
static_lung_compliance(500, 15, 5)

# Example 2: Low Compliance (ARDS)
# Vt 400 mL, Pplat 25 cmH2O, PEEP 10 cmH2O
# Cstat = 400 / (25 - 10) = 26.7 mL/cmH2O
static_lung_compliance(400, 25, 10)
}
