\name{step_by_step_febrile_infant}
\alias{step_by_step_febrile_infant}
\title{
Step-by-Step Approach for Febrile Infants
}
\description{
Calculates the risk stratification for Invasive Bacterial Infection (IBI) in febrile infants (typically <= 90 days old) using the "Step-by-Step" approach. This sequential algorithm allows for the identification of low-risk infants who may be managed without lumbar puncture or antibiotics.
}
\usage{
step_by_step_febrile_infant(age_days, ill_appearing, urinalysis_positive,
                            procalcitonin, crp_mg_l, absolute_neutrophil_count)
}
\arguments{
  \item{age_days}{
Numeric. Age of the infant in days.
}
  \item{ill_appearing}{
Numeric (0 or 1). Is the infant ill-appearing? (1 = Yes). If Yes, the patient is automatically High Risk.
}
  \item{urinalysis_positive}{
Numeric (0 or 1). Is there leukocyturia (positive urinalysis)? (1 = Yes). If Yes, the patient is High Risk.
}
  \item{procalcitonin}{
Numeric. Serum Procalcitonin level in ng/mL. (>= 0.5 ng/mL indicates High Risk).
}
  \item{crp_mg_l}{
Numeric. C-Reactive Protein level in mg/L. (> 20 mg/L indicates Intermediate Risk if previous steps are negative).
}
  \item{absolute_neutrophil_count}{
Numeric. Absolute Neutrophil Count (ANC) in cells/mm^3. (> 10,000 indicates Intermediate Risk if previous steps are negative).
}
}
\value{
A list containing:
\item{Risk_Classification}{The determined risk category (High Risk, Intermediate Risk, or Low Risk).}
\item{Recommendation}{Clinical guidance based on the risk level.}
}
\references{
Mintegi S, Bressan S, Gomez B, et al. Accuracy of a sequential approach to identify young febrile infants at low risk for invasive bacterial infection. Emerg Med J. 2014;31(e1):e19-24. doi:10.1136/emermed-2013-202449
Gomez B, Mintegi S, Bressan S, et al. Validation of the "Step-by-Step" Approach in the Management of Young Febrile Infants. Pediatrics. 2016;138(2). doi:10.1542/peds.2015-4381
}
\examples{

# Example 1: Low Risk
# 45 days old, Well-appearing, Neg UA, PCT 0.1, CRP 5, ANC 4000
step_by_step_febrile_infant(45, 0, 0, 0.1, 5, 4000)

# Example 2: High Risk (Procalcitonin)
# 60 days old, Well-appearing, Neg UA, PCT 0.8, CRP 10, ANC 5000
step_by_step_febrile_infant(60, 0, 0, 0.8, 10, 5000)

# Example 3: Intermediate Risk (CRP)
# 50 days old, Well, Neg UA, PCT 0.2, CRP 30, ANC 5000
step_by_step_febrile_infant(50, 0, 0, 0.2, 30, 5000)
}
