\name{travis_uc_criteria}
\alias{travis_uc_criteria}
\title{
Travis Criteria (Oxford Criteria) for Ulcerative Colitis
}
\description{
Calculates the Travis (Oxford) Criteria to predict the failure of intravenous corticosteroid therapy in patients with severe ulcerative colitis. The assessment is performed on Day 3 of treatment. Patients meeting the criteria have a significantly higher risk (approximately 85\%) of requiring colectomy.
}
\usage{
travis_uc_criteria(stool_frequency_day3, crp_day3)
}
\arguments{
  \item{stool_frequency_day3}{
Numeric. The number of stools passed on Day 3 of IV steroid treatment.
}
  \item{crp_day3}{
Numeric. The C-reactive protein level (mg/L) on Day 3 of IV steroid treatment.
}
}
\details{
The criteria for predicting a high risk of colectomy are:
\itemize{
  \item Stool frequency > 8 times/day OR
  \item Stool frequency > 3 times/day AND CRP > 45 mg/L
}
}
\value{
A list containing:
\item{Result}{Interpretation of the risk (High vs. Lower).}
\item{Predicted_Colectomy_Rate}{Estimated probability of requiring colectomy.}
}
\references{
Travis SP, Farrant JM, Ricketts C, et al. Predicting outcome in severe ulcerative colitis. Gut. 1996;38(6):905-910. doi:10.1136/gut.38.6.905
}
\examples{

# Example 1: High Risk (Frequency > 8)
# 9 stools, CRP 10
travis_uc_criteria(9, 10)

# Example 2: High Risk (Frequency > 3 and CRP > 45)
# 4 stools, CRP 50
travis_uc_criteria(4, 50)

# Example 3: Lower Risk
# 3 stools, CRP 60 (Frequency not > 3)
travis_uc_criteria(3, 60)
}
