\name{twist_score}
\alias{twist_score}
\title{
Testicular Workup for Ischemia and Suspected Torsion (TWIST) Score
}
\description{
Calculates the TWIST Score to stratify the risk of testicular torsion in male patients presenting with acute scrotal pain. The score helps identify patients who may require immediate surgical exploration versus those who can be safely managed with ultrasound or clinical observation.
}
\usage{
twist_score(testicular_swelling, hard_testicle, absent_cremasteric_reflex,
            nausea_vomiting, high_riding_testicle)
}
\arguments{
  \item{testicular_swelling}{
Numeric (0 or 1). Presence of testicular swelling. (1 = Yes, +2 points).
}
  \item{hard_testicle}{
Numeric (0 or 1). Presence of a hard testicle on palpation. (1 = Yes, +2 points).
}
  \item{absent_cremasteric_reflex}{
Numeric (0 or 1). Absence of the cremasteric reflex. (1 = Yes, +1 point).
}
  \item{nausea_vomiting}{
Numeric (0 or 1). Nausea or vomiting. (1 = Yes, +1 point).
}
  \item{high_riding_testicle}{
Numeric (0 or 1). High-riding testicle. (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{TWIST_Score}{The calculated total score (Range 0-7).}
\item{Risk_Category}{Classification (Low: 0-2, Intermediate: 3-4, High: 5-7).}
\item{Recommendation}{Clinical guidance regarding imaging and consultation.}
}
\references{
Barbosa JA, Tiseo BC, Barayan GA, et al. Development and initial validation of a scoring system to diagnose testicular torsion in children. J Urol. 2013;189(5):1859-1864. doi:10.1016/j.juro.2012.10.056
}
\examples{

# Example 1: High Risk
# Swelling (1), Hard (1), No Reflex (1), Nausea (0), High Riding (0)
# Score = 2 + 2 + 1 = 5
twist_score(1, 1, 1, 0, 0)

# Example 2: Low Risk
# No swelling, soft testicle, reflex present (0), nausea (1), normal position
# Score = 1
twist_score(0, 0, 0, 1, 0)
}
