% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_chart.R
\name{clock_chart}
\alias{clock_chart}
\title{The Simplest Clock Chart, Lines Unmodified}
\usage{
clock_chart(data, time, Col = "black")
}
\arguments{
\item{data}{A data frame}

\item{time}{Time in 24 hours. The allowed time formats for these family
of charts are \code{HH:MM:SS}, \code{HH:MM} or even \code{H:M} (such as \verb{12;30:09}
or \code{9:3}), although the SS part is ignored due to having
negligible impact on the final plot).}

\item{Col}{A single color name for the lines. The default is \code{black}.}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
There are five types of clock charts, \code{clock_chart()} being the simplest one.
It just shows the event times on a 24 hour clock. The lines are neither
colored, nor length modified. \code{clock_chart_col()} is used to colorize and
\code{clock_chart_len()} to change the length of the hands by a numeric vector.
To do both simultaneously, use \code{clock_chart_qnt()}. To use a qualitative
variable as the criterion, use \code{clock_chart_qlt()}.
}
\details{
Change the title, subtitle or the caption of the plot with
\code{ggplot2::labs()}.
}
\examples{
p1 <- clock_chart(smsclock, time) # Using package built-in data
p1 + ggplot2::labs(title = "SMS Receiving Times")
#  Add clock_chart(brintcity \%>\% filter(Origin == "Dhaka"), time = Departure)
}
\seealso{
\code{\link[=clock_chart_col]{clock_chart_col()}}, \code{\link[=clock_chart_qnt]{clock_chart_qnt()}}, and \code{\link[=clock_chart_qlt]{clock_chart_qlt()}}.
}
