% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustMD_InternalFunctions.R
\name{z.moments}
\alias{z.moments}
\title{Calculates the first and second moments of the latent data}
\usage{
z.moments(
  D,
  G,
  N,
  CnsIndx,
  OrdIndx,
  zlimits,
  mu,
  Sigma,
  Y,
  J,
  K,
  norms,
  nom.ind.Z,
  patt.indx
)
}
\arguments{
\item{D}{dimension of the latent data.}

\item{G}{number of mixture components.}

\item{N}{number of observations.}

\item{CnsIndx}{the number of continuous variables.}

\item{OrdIndx}{the sum of the number of continuous and ordinal (including
binary) variables.}

\item{zlimits}{the truncation points for the latent data.}

\item{mu}{a \code{D x G} matrix of means.}

\item{Sigma}{a \code{D x D x G} array of covariance parameters.}

\item{Y}{an \code{N x J} data matrix.}

\item{J}{the number of variables.}

\item{K}{the number of levels for each variable.}

\item{norms}{a matrix of standard normal deviates.}

\item{nom.ind.Z}{the latent dimensions corresponding to each nominal
variable.}

\item{patt.indx}{a list of length equal to the number of observed response 
patterns. Each entry of the list details the observations for which that
response pattern was observed.}
}
\value{
Output required for \code{clustMD} function.
}
\description{
Internal function.
}
\seealso{
\code{\link{clustMD}}
}
\keyword{internal}
