% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectStatements.R
\name{selectStatements}
\alias{selectStatements}
\title{Select Significant Statements from Concept Map Data}
\usage{
selectStatements(CMData, significanceThreshold = 0.05, verbose = TRUE, ...)
}
\arguments{
\item{CMData}{A data frame containing concept map data. The data should have at least the following columns:
\itemize{
\item \code{statement}: The text of the statement.
\item \code{sorterID}: The identifier for the sorter.
\item \code{stackID}: The identifier for the stack.
}}

\item{significanceThreshold}{A numeric value representing the significance threshold for the chi-squared test.
Statements with p-values less than this threshold are considered significant. Default is 0.05.}

\item{verbose}{Logical, if \code{TRUE}, additional information about the processing steps is printed to the console.}

\item{...}{Additional arguments to be passed to the chi-squared test (optional).}
}
\value{
A data frame with the same structure as the input, but with non-significant statements removed (if any).
If all statements are significant, the original data frame is returned unchanged.
}
\description{
This function selects statements from a concept map dataset based on their significance in terms of co-occurrence.
It applies a chi-squared test on the co-occurrence matrix of the statements to identify those that are statistically significant
(i.e., those that co-occur more frequently than would be expected by chance).
}
\examples{
# Simulate data with custom parameters:
set.seed(1)
myCMData <- simulateCardData(nSorters=40, pCorrect=.70, attributeWeights=c(1,1,1,1))

# Subject the data to sorter cluster analysis
myCMDataBySorters <- sorterMapping(myCMData)

# Select significant statements
mySelectedStatementsSorterCluster3 <- selectStatements(myCMDataBySorters[[1]])

}
\seealso{
\code{\link{chisq.test}} for chi-squared test functionality.
}
