% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_statvalues.R
\name{format_ttest}
\alias{format_ttest}
\title{Format t-test statistics}
\usage{
format_ttest(x, digits, pdigits, pzero, full, italics, dfs, mean, type)
}
\arguments{
\item{x}{An \code{htest} object from \code{\link[=cor.test]{cor.test()}}, \code{\link[=t.test]{t.test()}}, or \code{\link[=wilcox.test]{wilcox.test()}}.}

\item{digits}{Number of digits after the decimal for means, confidence
intervals, and test statistics.}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values).}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values.}

\item{full}{Logical value (default = TRUE) for whether to include means
and confidence intervals or just test statistic and p-value.}

\item{italics}{Logical value (default = TRUE) for whether \emph{p} label should be
italicized.}

\item{dfs}{Formatting for degrees of freedom ("par" = parenthetical,
"sub" = subscript, "none" = do not print degrees of freedom).}

\item{mean}{Formatting for mean label ("abbr" = M, "word" = Mean).}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX).}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

With \code{format_ttest()} you can format t-tests generated from \code{\link[=t.test]{t.test()}} and
\code{\link[=wilcox.test]{wilcox.test()}} output.
This is now an internal function superceded by \code{\link[=format_stats]{format_stats()}}, which we
recommend using instead.
}
\examples{
format_stats(t.test(formula = mtcars$mpg ~ mtcars$vs))
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_chisq}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.aov}()},
\code{\link{format_stats.easycorrelation}()},
\code{\link{format_stats.htest}()},
\code{\link{format_stats.lm}()},
\code{\link{format_stats.lmerModLmerTest}()},
\code{\link{format_stats.merMod}()}
}
\concept{functions for printing statistical objects}
