% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ews.R
\name{detect_warnings}
\alias{detect_warnings}
\title{Detect Early Warning Signals in a Time Series}
\usage{
detect_warnings(
  data,
  method = "rolling",
  metrics = "all",
  window = 0.5,
  burnin = 0.1,
  demean = TRUE,
  detrend = "none",
  threshold = 2,
  consecutive = 2L,
  bandwidth,
  span,
  degree
)
}
\arguments{
\item{data}{[\code{ts}, \code{numeric()}]\cr Univariate time series data.}

\item{method}{[\code{character(1)}]\cr Name of the analysis method.
Either \code{"rolling"} or \code{"expanding"} for rolling window and expanding
window, respectively.}

\item{metrics}{[\code{character(1)}]\cr Names of the EWS metrics to compute.
The default is \code{"all"} computing all metrics. The available options are:
\itemize{
\item \code{"ar1"}: The autoregressive coefficient of an AR1 model.
\item \code{"sd"}: Standard deviation.
\item \code{"skew"}: Skewness.
\item \code{"kurt"}: Kurtosis.
\item \code{"cv"}: Coefficient of variation.
\item \code{"rr"}: Return rate (\code{1 - ar1}).
\item \code{"all"}: All of the above.
}}

\item{window}{[\code{numeric(1)}]\cr Window size as a proportion of the total
series length (default \code{0.5}).}

\item{burnin}{[\code{numeric(1)}]\cr Burn-in period as a proportion of the total
series length (default \code{0.1}).}

\item{demean}{[\code{logical(1)}]\cr Should the time series be demeaned before
analysis?  If \code{TRUE} (the default), the \code{"ar1"} metric will be based on an
AR1 model where the mean of the observations is first subtracted.
See \code{\link[stats:ar.ols]{stats::ar.ols()}} for details.}

\item{detrend}{[\code{character(1)}]\cr Name of the detrending method to
apply to the time series data before computing the metrics.
The default is \code{"none"} for no detrending. The available options are:
\itemize{
\item \code{"gaussian"}: Estimates a smooth curve via kernel-based regression
using \code{\link[stats:ksmooth]{stats::ksmooth()}} with a Gaussian kernel which is then subtracted
from the time series.
\item \code{"loess"}: Estimates a smooth curve via local polynomial regression
using \code{\link[stats:loess]{stats::loess()}} which is then subtracted from the time series.
\item \code{"linear"}: Fits a linear regression model via \code{\link[stats:lm]{stats::lm()}} and uses
the residuals for computing the metrics.
\item \code{"first-diff"}: Uses the differences between the time series and its
first-order lagged values.
\item \code{"none"}: Use the original time series data.
}}

\item{threshold}{[\code{numeric(1)}]\cr The z-score threshold value for the
expanding window method. The default is \code{2.0}.}

\item{consecutive}{[\code{integer(1)}]\cr The number of times the \code{threshold}
has to be crossed consecutively to be counted as a detection. The default
is \code{2}.}

\item{bandwidth}{See \code{\link[stats:ksmooth]{stats::ksmooth()}}.}

\item{span}{See \code{\link[stats:loess]{stats::loess()}}.}

\item{degree}{See \code{\link[stats:loess]{stats::loess()}}.}
}
\value{
An object of class \code{ews} containing the EWS results as a \code{tibble}.
}
\description{
Detect Early Warning Signals in a Time Series
}
\examples{
set.seed(123)
ts_data <- stats::arima.sim(list(order = c(1, 1, 0), ar = 0.6), n = 200)

# Rolling window (default)
ews_roll <- detect_warnings(ts_data)

# Expanding window
ews_exp <- detect_warnings(ts_data, method = "expanding")

}
