% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.regimes}
\alias{plot.regimes}
\title{Plot Time Series Data with Detected Regime Stability}
\usage{
\method{plot}{regimes}(x, points = FALSE, ...)
}
\arguments{
\item{x}{[\code{regimes}]\cr Output of \code{\link[=detect_regimes]{detect_regimes()}}.}

\item{points}{[\code{logical(1)}]\cr Should a point be added for each
observation?  The points are colored by regime stability
(default: \code{FALSE}).}

\item{...}{Ignored.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot Time Series Data with Detected Regime Stability
}
\examples{
set.seed(123)
ts_data <- stats::arima.sim(list(order = c(1, 1, 0), ar = 0.6), n = 200)
regimes <- detect_regimes(
  data = ts_data,
  method = "threshold",
  sensitivity = "medium"
)
plot(regimes)

}
