% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.regimes}
\alias{print.regimes}
\title{Print Regime Detection Results}
\usage{
\method{print}{regimes}(x, ...)
}
\arguments{
\item{x}{[\code{regimes}]\cr A regime detection result from \code{\link[=detect_regimes]{detect_regimes()}}.}

\item{...}{Additional arguments passed to the generic print method.}
}
\value{
\code{x} (invisibly).
}
\description{
Print Regime Detection Results
}
\examples{
set.seed(123)
ts_data <- stats::arima.sim(list(order = c(1, 1, 0), ar = 0.6), n = 200)
regimes <- detect_regimes(
  data = ts_data,
  method = "threshold",
  sensitivity = "medium"
)
print(regimes)

}
