% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs.R
\encoding{UTF-8}
\name{bs}
\alias{bs}
\title{Build multiple networks and select the best one from a multi-omics data set}
\usage{
bs(
  data,
  p = NULL,
  pX = lifecycle::deprecated(),
  lambda_w = NULL,
  lambda_b = NULL,
  c = NULL,
  nlambda_w = NULL,
  nlambda_b = NULL,
  nc = NULL,
  lambda_w_max = NULL,
  lambda_b_max = NULL,
  c_max = NULL,
  lambda_w_min_ratio = NULL,
  lambda_b_min_ratio = NULL,
  c_min = NULL,
  icov_guess = NULL,
  cov_output = FALSE,
  lock_lambdas = FALSE,
  method = "xestars",
  stars_thresh = 0.1,
  stars_subsample_ratio = NULL,
  rep_num = 20,
  max_iter = 10,
  old_sampling = FALSE,
  ebic_gamma = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{data}{The input multi-omics data set. Rows should be samples, columns
should be variables. Variables should be grouped by their assay (e.g.
transcripts first, then metabolites). \code{data} is a required parameter.}

\item{p}{A vector with with the number of variables for each omic layer of the
data set (e.g. the number of transcripts, metabolites etc.), in the same
order the layers have in the data set. If given a single number,
\code{coglasso()} assumes that the total of data sets is two, and that the
number given is the dimension of the first one.}

\item{pX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{pX} is no longer supported.
Please use \code{p}.}

\item{lambda_w}{A vector of values for the parameter \eqn{\lambda_w}, the
penalization parameter for the "within" interactions. Overrides
\code{nlambda_w}.}

\item{lambda_b}{A vector of values for the parameter \eqn{\lambda_b}, the
penalization parameter for the "between" interactions. Overrides
\code{nlambda_b}.}

\item{c}{A vector of values for the parameter \eqn{c}, the weight given to
collaboration. Overrides \code{nc}.}

\item{nlambda_w}{The number of requested \eqn{\lambda_w} parameters to
explore. A sequence of size \code{nlambda_w} of \eqn{\lambda_w} parameters will
be generated. Defaults to 8. Ignored when \code{lambda_w} is set by the user.}

\item{nlambda_b}{The number of requested \eqn{\lambda_b} parameters to
explore. A sequence of size \code{nlambda_b} of \eqn{\lambda_b} parameters will
be generated. Defaults to 8. Ignored when \code{lambda_b} is set by the user.}

\item{nc}{The number of requested \eqn{c} parameters to explore. A sequence
of size \code{nc} of \eqn{c} parameters will be generated. Defaults to 5.
Ignored when \code{c} is set by the user.}

\item{lambda_w_max}{The greatest generated \eqn{\lambda_w}. By default it is
computed with a data-driven approach. Ignored when \code{lambda_w} is set by the
user.}

\item{lambda_b_max}{The greatest generated \eqn{\lambda_b}. By default it is
computed with a data-driven approach. Ignored when \code{lambda_b} is set by the
user.}

\item{c_max}{The greatest \eqn{c} explored. Defaults to 100. Ignored when \code{c}
is set by the user.}

\item{lambda_w_min_ratio}{The ratio of the smallest generated \eqn{\lambda_w}
over the greatest generated \eqn{\lambda_w}. Defaults to 0.1. Ignored when
\code{lambda_w} is set by the user.}

\item{lambda_b_min_ratio}{The ratio of the smallest generated \eqn{\lambda_b}
over the greatest generated \eqn{\lambda_b}. Defaults to 0.1. Ignored when
\code{lambda_b} is set by the user.}

\item{c_min}{The the smallest \eqn{c} explored. Defaults to
\eqn{\frac{1}{c_{max}}}, so to 0.01 if \code{c_max} is not set by the user.
Ignored when \code{c} is set by the user.}

\item{icov_guess}{Use a predetermined inverse covariance matrix as an initial
guess for the network estimation.}

\item{cov_output}{Add the estimated variance-covariance matrix to the output.}

\item{lock_lambdas}{Set \eqn{\lambda_w = \lambda_b}. Force a single lambda
parameter for both "within" and "between" interactions.}

\item{method}{The model selection method to select the best combination of
hyperparameters. The available options are "xstars", "xestars" and "eBIC".
Defaults to "xestars".}

\item{stars_thresh}{The threshold set for variability of the explored
networks at each iteration of the algorithm. The \eqn{\lambda_w} or the
\eqn{\lambda_b} associated to the most stable network before the threshold
is overcome is selected.}

\item{stars_subsample_ratio}{The proportion of samples in the multi-omics
data set to be randomly subsampled to estimate the variability of the
network under the given hyperparameters setting. Defaults to 80\% when the
number of samples is smaller than 144, otherwise it defaults to
\eqn{\frac{10}{n}\sqrt{n}}.}

\item{rep_num}{The amount of subsamples of the multi-omics data set used to
estimate the variability of the network under the given hyperparameters
setting. Defaults to 20.}

\item{max_iter}{The greatest number of times the algorithm is allowed to
choose a new best \eqn{\lambda_w}. Defaults to 10.}

\item{old_sampling}{Perform the same subsampling \code{xstars()} would if set to
TRUE. Makes a difference with bigger data sets, where computing
a correlation matrix could take significantly longer. Defaults to FALSE.}

\item{ebic_gamma}{The \eqn{\gamma} tuning parameter for \emph{eBIC} selection, to set
between 0 and 1. When set to 0 one has the standard \emph{BIC}. Defaults to 0.5.}

\item{verbose}{Print information regarding the network building and the
network selection processes.}
}
\value{
\code{bs()} returns an object of \code{S3} class \code{select_coglasso} containing
several elements. The most
important is probably \code{sel_adj}, the adjacency matrix of the
selected network. Some output elements depend on the chosen model selection
method.\cr
These elements are always returned, and they are the result of network
estimation with \code{\link[=coglasso]{coglasso()}}:
\itemize{
\item \code{loglik} is a numerical vector containing the \eqn{log} likelihoods of all
the estimated networks.
\item \code{density} is a numerical vector containing a measure of the density of all
the estimated networks.
\item \code{df} is an integer vector containing the degrees of freedom of all the
estimated networks.
\item \code{convergence} is a binary vector containing whether a network was
successfully estimated for the given combination of hyperparameters or not.
\item \code{path} is a list containing the adjacency matrices of all the estimated
networks.
\item \code{icov} is a list containing the inverse covariance matrices of all the
estimated networks.
\item \code{nexploded} is the number of combinations of hyperparameters for which
\code{coglasso()} failed to converge.
\item \code{data} is the input multi-omics data set.
\item \code{hpars} is the ordered table of all the combinations of hyperparameters
given as input to \code{bs()}, with \eqn{\alpha(\lambda_w+\lambda_b)}
being the key to sort rows.
\item \code{lambda_w}, \code{lambda_b}, and \code{c} are numerical vectors with,
respectively, all the \eqn{\lambda_w}, \eqn{\lambda_b}, and \eqn{c} values
\code{bs()} used.
\item \code{p} is the vector with the number of variables for each omic layer of the
data set.
\item \code{D} is the number of omics layers in the data set.
\item \code{cov} optional, returned when \code{cov_output} is TRUE, is a list containing
the variance-covariance matrices of all the estimated networks.
}
These elements are returned by all selection methods available:
\itemize{
\item \code{sel_index_c}, \code{sel_index_lw} and \code{sel_index_lb} are the indexes of the
final selected parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b}
leading to the most stable sparse network.
\item \code{sel_c}, \code{sel_lambda_w} and \code{sel_lambda_b} are the final selected
parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b} leading to the most
stable sparse network.
\item \code{sel_adj} is the adjacency matrix of the final selected network.
\item \code{sel_density} is the density of the final selected network.
\item \code{sel_icov} is the inverse covariance matrix of the final selected network.
\item \code{sel_cov} optional, given only when \code{coglasso()} was called with
\code{cov_output = TRUE}. It is the covariance matrix associated with the final
selected network.
\item \code{call} is the matched call.
\item \code{method} is the chosen model selection method.
}
These are the additional elements returned when choosing "xestars" or "xstars":
\itemize{
\item \code{merge} is the "merged" adjacency matrix, the average of all the adjacency
matrices estimated across all the different subsamples for the selected
combination of \eqn{\lambda_w}, \eqn{\lambda_b}, and \eqn{c} values in the
last path explored before convergence. Each entry is a measure of how
recurrent the corresponding edge is across the subsamples.
\item \code{variability_lw}, \code{variability_lb} and \code{variability_c} are numeric vectors
of as many items as the number of \eqn{\lambda_w}, \eqn{\lambda_b}, and
\eqn{c} values explored. Each item is the variability of the network
estimated for the corresponding hyperparameter value, keeping the other two
hyperparameters fixed to their selected value.
\item \code{sel_variability} is the variability of the final selected network.
}
These are the additional elements returned when choosing "ebic":
\itemize{
\item \code{ebic_scores} is a numerical vector containing the eBIC scores for all the
hyperparameter combination.
}
}
\description{
\code{bs()} wraps the two main functions of the package in a single one:
\code{\link[=coglasso]{coglasso()}}, to build multiple multi-omics networks, and \code{\link[=select_coglasso]{select_coglasso()}}
to select the best one according to the chosen criterion.
}
\details{
When using \code{bs()}, first, \code{\link[=coglasso]{coglasso()}} estimates multiple multi-omics networks
with the algorithm \emph{collaborative graphical lasso}, one for each combination
of input values for the hyperparameters \eqn{\lambda_w}, \eqn{\lambda_b} and
\eqn{c}. Then, \code{\link[=select_coglasso]{select_coglasso()}} selects the best combination of
hyperparameters given to \code{coglasso()} according to the selected model
selection method. The three availble options that can be set for the argument
\code{method} are  "xstars", "xestars" and "ebic". For more information on these
selection methods, visit the help page of \code{\link[=select_coglasso]{select_coglasso()}}.
}
\examples{
# Suggested usage: give the input data set, set the values for `p` and the 
# number of hyperparameters to explore (to choose how extensively to explore 
# the possible hyperparameters). Then, let the default behavior do the rest:

sel_mo_net <- bs(multi_omics_sd_micro, p = c(4, 2), nlambda_w = 3, 
                 nlambda_b = 3, nc = 3, verbose = FALSE)

}
