% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_column_drift.R
\name{detect_column_drift}
\alias{detect_column_drift}
\title{Detect Column-Level Data Drift}
\usage{
detect_column_drift(reference, target, alpha = 0.05)
}
\arguments{
\item{reference}{A data.frame representing baseline data}

\item{target}{A data.frame representing new incoming data}

\item{alpha}{Significance level for drift detection}
}
\value{
A data.frame with drift statistics per column
}
\description{
Compares reference and target datasets to identify column-level drift
using statistical distance measures.
}
\examples{
ref <- data.frame(
  age = c(25, 30, 35, 40),
  city = c("A", "B", "A", "C")
)

new <- data.frame(
  age = c(26, 31, 36, 41),
  city = c("A", "B", "C", "C")
)

detect_column_drift(ref, new)

}
