% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif_df.R
\name{vif_df}
\alias{vif_df}
\title{Compute variance inflation factors dataframe}
\usage{
vif_df(df = NULL, predictors = NULL, quiet = FALSE, ...)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{predictors}{(optional; character vector or NULL) Names of the
predictors in \code{df}. If NULL, all columns except \code{responses} and
constant/near-zero-variance columns are used. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
dataframe with columns:
\itemize{
\item \code{predictor}: Character, predictor name.
\item \code{vif}: Numeric, variance inflation factor
}
}
\description{
Computes the pairwise correlation matrix between all pairs of predictors via \code{\link[=cor_df]{cor_df()}} and \code{\link[=cor_matrix]{cor_matrix()}}, applies \code{\link[=vif]{vif()}} to the resulting matrix to compute Variance Inflation Factors, and returns the result as a dataframe.
}
\section{Variance Inflation Factors}{


VIF for predictor \eqn{a} is computed as \eqn{1/(1-R^2)}, where \eqn{R^2} is
the multiple R-squared from regressing \eqn{a} on the other predictors.
Recommended maximums commonly used are 2.5, 5, and 10.
}

\examples{

data(vi_smol)

# ## OPTIONAL: parallelization setup
# ## irrelevant when all predictors are numeric
# ## only worth it for large data with many categoricals
# future::plan(
#   future::multisession,
#   workers = future::availableCores() - 1
# )

# ## OPTIONAL: progress bar
# progressr::handlers(global = TRUE)

#predictors
predictors = c(
  "koppen_zone", #character
  "soil_type", #factor
  "topo_elevation", #numeric
  "soil_temperature_mean" #numeric
)

x <- vif_df(
  df = vi_smol,
  predictors = predictors
)

x

## OPTIONAL: disable parallelization
#future::plan(future::sequential)

}
\references{
\itemize{
\item David A. Belsley, D.A., Kuh, E., Welsch, R.E. (1980). Regression Diagnostics: Identifying Influential Data and Sources of Collinearity. John Wiley & Sons. DOI: 10.1002/0471725153.
}
}
\seealso{
Other multicollinearity_assessment: 
\code{\link{collinear_stats}()},
\code{\link{cor_clusters}()},
\code{\link{cor_cramer}()},
\code{\link{cor_df}()},
\code{\link{cor_matrix}()},
\code{\link{cor_stats}()},
\code{\link{vif}()},
\code{\link{vif_stats}()}
}
\concept{multicollinearity_assessment}
