% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/it_metric.R
\name{it_metric}
\alias{it_metric}
\title{Calculates an Information Theory-based metric}
\usage{
it_metric(x, metric, base = "log2", ordered = TRUE)
}
\arguments{
\item{x}{A matrix - an output of the \code{\link[=get_coma]{get_coma()}} function}

\item{metric}{One of the following: "ent" (Marginal entropy), "joinent" (Joint entropy), "condent" (Conditional entropy), "mutinf" (Mutual information), or "relmutinf" (Relative mutual information)}

\item{base}{The unit in which entropy is measured.
The default is "log2", which compute entropy in "bits".
"log" and "log10" can be also used.}

\item{ordered}{The type of pairs considered.
Either "ordered" (TRUE) or "unordered" (FALSE).
The default is TRUE.}
}
\value{
A single numeric value
}
\description{
Calculates a selected Information Theory-based metric based on a provided co-occurrence matrix
}
\examples{
library(comat)
data(raster_x, package = "comat")

com = get_coma(raster_x)
com

it_metric(com, metric = "ent")
it_metric(com, metric = "joinent")
it_metric(com, metric = "condent")
it_metric(com, metric = "mutinf")
it_metric(com, metric = "relmutinf")
}
\references{
Nowosad J., TF Stepinski. 2019. Information theory as a consistent framework
for quantification and classification of landscape patterns. https://doi.org/10.1007/s10980-019-00830-x
}
