#'
#' Impurity data in a chemical product (IDCP).
#'
#' This data were collected in an experiment to assess the impurity present in a chemical product.
#' The impurity is affected by two factors: pressure and temperature. Montgomery (2001, p. 193)
#' analyzed the data by using the Tukey single-degree-of-freedom test
#' and concluded that there is no evidence of interaction.
#' @name IDCP
#' @format A matrix with five rows (Pressures) and three columns (Temperatures):
#' \describe{
#'   \item{Row1}{Pressure 25}
#'   \item{Row2}{Pressure 30}
#'   \item{Row3}{Pressure 35}
#'   \item{Row4}{Pressure 40}
#'   \item{Row5}{Pressure45}
#'   \item{Column1}{Temperature 100}
#'   \item{Column2}{Temperature 125}
#'   \item{Column3}{Temperature 150}
#' }
#' @references
#' \enumerate{
#' \item
#'  Montgomery, D. C. (2001). Design and analysis of experiments, 5th Edition, p 193.
#'  John Wiley & Sons.
#' }
#'
NULL
