% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcalc.R
\name{PJacobi}
\alias{PJacobi}
\title{The Jacobi method}
\usage{
PJacobi(A, b, x0 = NULL, tol = 1e-06, nmax = 1e+05, ddominant = TRUE)
}
\arguments{
\item{A}{The \eqn{n \times n} matrix of coefficients of the 
unknowns in the linear system.}

\item{b}{A vector of \eqn{n} constants representing the right-hand 
side of the linear system. This function does not work out
solutions of homogeneous systems, where the b is a vector
of zeros (null vector). Therefore input with b equal to a
null vector is rejected.}

\item{x0}{A vector of \eqn{n} starting numeric values for the 
iterations. If no values are entered for x0, a column of 
zero will be adopted by default.}

\item{tol}{A real number indicating the threshold under which the
relative increment from one solution approximation to
the next is small enough to stop iteration. The default
value is \code{tol=1e-6}.}

\item{nmax}{An integer. The maximum number of iterations allowed,
if convergence according to the criterion is not reached.}

\item{ddominant}{A logical variable. If FALSE, the method is applied 
also if the matrix of coefficients is not
diagonally dominant (default is TRUE).}
}
\value{
A numeric vector of length \eqn{n} with values approximating
        the system's solution.
}
\description{
Implementation of the Jacobi iterative method to solve a 
system \eqn{Ax=b} of \eqn{n} linear equations in \eqn{n} unknowns.
}
\details{
The Jacobi method guarantees a finite solution for linear systems
characterised by a diagonally dominant matrix \eqn{A} of 
coefficients. This means that each element on its diagonal must be,
in absolute value, larger than the sum of the absolute value of
all the elements in the corresponding row.
}
\examples{
# Simple system with solution 1,2,3
A <- matrix(c(3,1,2,-1,-4,2,1,1,7),ncol=3)
b <- c(4,-4,27)

# Solution
x <- PJacobi(A,b)
print(x)

# Start from a different point
x0 <- c(-1,2,8)
x <- PJacobi(A,b,x0)
print(x)

}
