% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deriv.R
\name{backdif}
\alias{backdif}
\title{Backward differences}
\usage{
backdif(f)
}
\arguments{
\item{f}{A vector of real numbers. Tabulated (known) values 
of the function, corresponding to a regular grid.}
}
\value{
A lower triangular matrix with \eqn{n+1} rows and
\eqn{n+1} columns. The first column includes the tabulated 
values of the function. The second column includes a zero
and the \eqn{n} backward differences of first order. The third
column includes two zeros and the \eqn{n-1} forward 
differences of second order. And so on.
}
\description{
Computes backward differences of all orders up to n, based
on n+1 tabulated points on a regular grid.
}
\details{
The backward difference of first order is
\deqn{
 f(x_i)-f(x_i-h)
}
Backward differences of higher orders follow from this one,
where the function \eqn{f} is replaced by the backward
difference of previous order. All values are contained in a
\eqn{(n+1)\times(n+1)} lower triangular matrix.
}
\examples{
# Tabulated values: f(x) = x^3+x^2-x-1
x <- c(0,1,2,3)
f <- x^3+x^2-x-1

# Triangular matrix with backward differences
B <- backdif(f)
print(B)

}
