% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcalc.R
\name{condet}
\alias{condet}
\title{Determinant of a square matrix}
\usage{
condet(A)
}
\arguments{
\item{A}{An \eqn{n\times n} square matrix of.}
}
\value{
A real number corresponding to the determinant
        of A.
}
\description{
Calculates the determinant of a square matrix of size
\eqn{n}, using the reduction of the matrix in upper
triangular form.
}
\examples{
# Identity matrix of size 10
A <- diag(10)
print(condet(A))

# Random matrix with integer elements
A <- matrix(sample(-5:5,size=25,replace=TRUE),ncol=5)
print(condet(A))

}
