% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{decidepoly_n}
\alias{decidepoly_n}
\title{Degree of best-interpolating polynomial}
\usage{
decidepoly_n(x, f, thr = 1e-06, ntrial = 30)
}
\arguments{
\item{x}{A vector of real numbers. Grid points corresponding to the tabulated
(known) values of the function.}

\item{f}{A vector of real numbers. Tabulated (known) values of the function, 
corresponding to the grid \code{x}.}

\item{thr}{A real number. This is the threshold to decide
when a column in the triangular matrix of
divided differences has a small-enough average 
value (small than \code{thr}). Default is
\code{thr=1e-6}.}

\item{ntrial}{A positive integer to decide how many random
selections of the provided known (tabulated)
points have to be carried out. Default is
\code{ntrial=30}.}
}
\value{
An integer corresponding to the best interpolating
        polynomial's degree.
}
\description{
The degree is chosen making use of divided differences. 
As more and more points are used for the interpolation, 
the components of columns of divided differences
corresponding to higher orders, are smaller and smaller. 
They are exactly zero when the function to interpolate is 
a polynomial of degree, say, \eqn{k}. More specifically, 
all divided differences of order \eqn{k+1} and above are 
exactly zero. The criterion used suggests a value \eqn{k} 
if the average of the absolute value of all divided 
differences of order \eqn{k+1} is less than a given 
threshold \code{thr} (default 1e-6).
}
\details{
The divided differences depend on the specific points 
selected to calculate the interpolated curve. To avoid 
potential bias that might occur when the tabulated 
points used are not distributed uniformly, several random 
selections of tabulated points are performed (default
\code{ntrial=30}) and the highest \eqn{k} is returned.
}
\examples{
# Tabulated grid points for function cos(x)
x <- seq(0,3*pi/2,length=20)
f <- cos(x)

# Suggested polynomial degree (default ntrial)
k <- decidepoly_n(x,f)
print(k)

# Increase number of random selections (ntrial=50)
k <- decidepoly_n(x,f,ntrial=50)
print(k)

}
