% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integ.R
\name{numint_reg}
\alias{numint_reg}
\title{Numerical integration using the trapezoid or simpson's rule}
\usage{
numint_reg(x, f, scheme = "sim13")
}
\arguments{
\item{x}{A vector of real numbers. Grid points corresponding 
to the tabulated (known) values of the function. These must be
equally spaced (regular grid).}

\item{f}{A vector of real numbers. Tabulated (known) values 
of the function, corresponding to the grid \code{x}.}

\item{scheme}{A character indicating the integration rule to
follow. Possible values are "trap" (trapezoid rule),
"sim13" (Simpson's 1/3 rule), and "sim38" (Simpson's
3/8 rule). Default scheme is "sim13".}
}
\value{
A real number, corresponding to the numeric approximation
of the definite integral of \eqn{f(x)}.
}
\description{
Computes the definite integral of \eqn{f(x)} between \eqn{a}
and \eqn{b}, using one of the three numerical integration
Newton-Cotes rules, trapezoid, Simpson's 1/3 or Simpson's 3/8.
}
\details{
The default method is Simpson's 1/3 rule. For this method to
be applied correctly, the number of regular intervals must be
even. If this is not the case, the area corresponding to the
last interval will be calculated with the trapezoid rule with
a warning being posted.

When using the Simpson's 3/8 rule, the number of regular
intervals must be a multiple of 3. If this is not the case,
the last or last two intervals will be computed with the
trapezoid rule.
}
\examples{
# Tabulated values: f(x) = x^2
x <- seq(0,2,length.out=21) # number of intervals is even
f <- x^2

# Integral between 0 and 2
# The correct result is 2^3/3=8/3=2.6666...
nvalue <- numint_reg(x,f) # Defaul nethod simpson's 1/3
print(nvalue)

# If the number of intervals is not even,
# a warning is issued
y <- seq(0,2,length.out=22)
g <- y^2
nvalue <- numint_reg(y,g)
print(nvalue)

}
