% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getGSDesign}
\alias{getGSDesign}
\title{Get Group Sequential Design}
\usage{
getGSDesign(info.rates = NULL, looks = NULL, as.type = "asOF")
}
\arguments{
\item{info.rates}{Analysis times expressed as rate of information accrual. Expects a vector
with the last item representing the final analysis and equal to 1.
For example, information rates for two-stage trial with interim analysis half way through is c(0.5, 1).
One of two options for expressing analysis times. Either 'info.rates' or 'looks' must be specified.}

\item{looks}{Analysis times expressed by number of patients accrued at each point. Expects a vector
with the last item being equal to the maximum sample size. For example.
looks for a three stage trial with maximum sample size of 300 and analysis planned every 100 patients is c(100, 100, 100).
One of two options for expressing analysis times. Either 'info.rates' or 'looks' must be specified.}

\item{as.type}{Time of alpha spending function to use. Options are as outlined by 'rpact'.
Default is 'asOF' \(O'Brien-Fleming-type\).}
}
\value{
Returns an 'rpact' TrialDesign object.
}
\description{
Generate boundaries for a group sequential design using a one-sided test
}
\details{
To generate confidence-based thresholds, we are interested in a one-sided test and alpha is set at 0.025.
To generate the stopping thresholds, specify either looks or information rates, and the alpha spending function if
difference from O-Brien-Fleming-type.
}
\examples{
# calculate critical values for a two-stage trial with an interim analysis half-way through
# Use Pocock-type alpha spending
design <- getGSDesign(info.rates = c(0.5, 1), as.type = 'asP')
critical.stagewise.alpha.levels <- design$stageLevels

# calculate values for a 6-stage trial with a maximum sample size of 1000
# interim analysis begins at 500 patients accrued and continues every 100 patients after
design <- getGSDesign(looks = seq(500, 1000, 100))
}
\seealso{
\code{\link[rpact:getDesignGroupSequential]{rpact::getDesignGroupSequential()}}
}
