% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialDesignFns.R
\name{getSuffStats}
\alias{getSuffStats}
\title{Get Sufficient Statistics}
\usage{
getSuffStats(datlist)
}
\arguments{
\item{datlist}{The current data list at the point of analysis generated from \code{getCurrentData}.
The list must have a \code{KNOWN} field.}
}
\value{
List of sufficient statistics

\itemize{
\item{num.enrolled}
\item{num.known}
\item{num.uknown}
\item{num.resp}
\item{num.fail}
\item{resprate}
\item{formattedrate}}
}
\description{
Get sufficient statistics from trial data necessary to perform primary analysis
}
\details{
Given a data list, this checks if the responses are binary (two types of responses),
ordinal (more than 2 or less than 30 different response types) or continuous (other). If continuous, mean and standard
deviations are returned. This code is not necessarily used in singleTrial since the perpetual functionality was
introduced as there are additional methods to retrieve the statistics necessary to perform the analysis that take
into account the possibility that arms have been dropped or added.
}
\examples{
# load data set
data(datlist)
looks <- seq(500,1000,100)
# first interim analysis
n.at.look = looks[1]
looktime.interim = datlist$arrival.day[n.at.look]
currdatlist.interim <- getCurrentData(datlist, looktime.interim, n.at.look, as.followup=TRUE)
suffStats  <- getSuffStats(currdatlist.interim)
}
