% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume.R
\name{connector_databricks_volume}
\alias{connector_databricks_volume}
\title{Create databricks volume connector}
\usage{
connector_databricks_volume(
  full_path = NULL,
  catalog = NULL,
  schema = NULL,
  path = NULL,
  extra_class = NULL,
  force = FALSE,
  ...
)
}
\arguments{
\item{full_path}{Full path to the file storage in format
\code{catalog/schema/path}. If NULL, \code{catalog}, \code{schema}, and \code{path} must be
provided.}

\item{catalog}{Databricks catalog}

\item{schema}{Databricks schema}

\item{path}{Path to the file storage}

\item{extra_class}{Extra class to assign to the new connector.}

\item{force}{If TRUE, the volume will be created without
asking if it does not exist.}

\item{...}{Additional arguments passed to the \link[connector:Connector]{connector::connector}}
}
\value{
A new \link{ConnectorDatabricksVolume} object
}
\description{
Create a new databricks volume connector object.
See \link{ConnectorDatabricksVolume} for details.

Initializes the connector for Databricks volume storage.
}
\details{
The \code{extra_class} parameter allows you to create a subclass of the
\code{ConnectorDatabricksVolume} object. This can be useful if you want to create
a custom connection object for easier dispatch of new s3 methods, while still
inheriting the methods from the \code{ConnectorDatabricksVolume} object.
}
\examples{
\dontrun{
# Connect to a file system
databricks_volume <- "catalog/schema/path"
db <- connector_databricks_volume(databricks_volume)

db

# Create subclass connection
db_subclass <- connector_databricks_volume(databricks_volume,
  extra_class = "subclass"
)

db_subclass
class(db_subclass)
}
}
