% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-ContainerR6.R
\docType{class}
\name{Iterable}
\alias{Iterable}
\title{Iterable abstract class interface}
\description{
An \link{Iterable} is an object that provides an \code{\link[=iter]{iter()}} method,
which is expected to return an \link{Iterator} object. This class defines the
abstract class interface such that each class inheriting this class provides
an \code{\link[=iter]{iter()}} method and must implement a private method \code{create_iter()},
which must return an \link{Iterator} object.
}
\seealso{
\link{Iterator} and \link{Container}
}
\author{
Roman Pahl
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Iterable-new}{\code{Iterable$new()}}
\item \href{#method-Iterable-iter}{\code{Iterable$iter()}}
\item \href{#method-Iterable-clone}{\code{Iterable$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterable-new"></a>}}
\if{latex}{\out{\hypertarget{method-Iterable-new}{}}}
\subsection{Method \code{new()}}{
\code{Iterable} is an abstract class and thus cannot be instantiated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterable$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterable-iter"></a>}}
\if{latex}{\out{\hypertarget{method-Iterable-iter}{}}}
\subsection{Method \code{iter()}}{
Create iterator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterable$iter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
returns the \code{Iterator} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Iterable-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Iterable-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Iterable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
