% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_name.R
\name{has_name}
\alias{has_name}
\alias{has_name.Container}
\alias{has_name.dict.table}
\title{Check for Name}
\usage{
has_name(x, name)

\method{has_name}{Container}(x, name)

\method{has_name}{dict.table}(x, name)
}
\arguments{
\item{x}{any \code{R} object.}

\item{name}{\code{character} the name to be found.}
}
\value{
\code{TRUE} if name is in \code{x} and otherwise \code{FALSE}.

For \code{dict.table} \code{TRUE} if the dict.table objects has the given
column name, otherwise \code{FALSE}.
}
\description{
Check for Name
}
\examples{

co = container(a = 1, 2, f = mean)
has_name(co, "a")    # TRUE
has_name(co, "f")    # TRUE
has_name(co, "2")    # FALSE

dit = dict.table(a = 1:2, b = 3:4)
has_name(dit, "a")   # TRUE
has_name(dit, "x")   # FALSE
}
\seealso{
\code{\link[=has]{has()}}
}
