% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_distribution.R
\name{calculate_word_distribution}
\alias{calculate_word_distribution}
\title{Calculate word distribution across text segments or sections}
\usage{
calculate_word_distribution(
  text,
  selected_words,
  use_sections = "auto",
  n_segments = 10,
  remove_stopwords = TRUE,
  language = "en"
)
}
\arguments{
\item{text}{Character string or named list. Document text or text with sections.}

\item{selected_words}{Character vector. Words/n-grams to track.}

\item{use_sections}{Logical or "auto". Use document sections if available (default: "auto").}

\item{n_segments}{Integer. Number of segments if not using sections (default: 10).}

\item{remove_stopwords}{Logical. Remove stopwords before analysis (default: TRUE).}

\item{language}{Character. Language for stopwords (default: "en").}
}
\value{
Tibble with columns:
\itemize{
\item segment_id: Segment identifier
\item segment_name: Section name or segment number
\item segment_type: "section" or "equal_length"
\item word: Word/n-gram
\item count: Absolute frequency
\item total_words: Total words in segment
\item relative_frequency: Proportion of total words
\item percentage: Percentage representation
}
Attributes include metadata about segmentation used.
}
\description{
Calculates the frequency of selected words/n-grams across document sections
or equal-length segments.
}
\details{
The function:
\itemize{
\item Automatically detects if sections are available
\item Removes stopwords before creating n-grams (if requested)
\item Supports unigrams, bigrams, trigrams, etc.
\item Calculates both absolute and relative frequencies
}
}
\examples{
\dontrun{
doc <- pdf2txt_auto("paper.pdf")

# Track specific words across sections
words_to_track <- c("machine learning", "neural network", "accuracy")
dist <- calculate_word_distribution(doc, words_to_track)

# Use equal-length segments instead
dist <- calculate_word_distribution(doc, words_to_track,
                                    use_sections = FALSE,
                                    n_segments = 20)
}

}
