% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuesenberryHurst_Wilson_score_CIs_1xc.R
\name{QuesenberryHurst_Wilson_score_CIs_1xc}
\alias{QuesenberryHurst_Wilson_score_CIs_1xc}
\title{The Quesenberry-Hurst Wilson score simultaneous intervals for the multinomial probabilities}
\usage{
QuesenberryHurst_Wilson_score_CIs_1xc(n, alpha = 0.05)
}
\arguments{
\item{n}{the observed counts (a 1xc vector, where c is the number of categories)}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Quesenberry-Hurst Wilson score simultaneous intervals for the multinomial probabilities

(with Scheffe adjustment)

Described in Chapter 3 "The 1xc Table and the Multinomial Distribution"
}
\examples{
# Genotype counts for SNP rs 6498169 in RA patients
QuesenberryHurst_Wilson_score_CIs_1xc(n = snp6498169$complete$n)
}
