% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_wrapper.R
\name{run_convergence_robustness_tests}
\alias{run_convergence_robustness_tests}
\title{Run comprehensive robustness test suite}
\usage{
run_convergence_robustness_tests(
  results_robust,
  X_matrix,
  Y_matrix,
  path_cpi = NULL,
  path_weights = NULL,
  sector_names = NULL,
  run_permutation = TRUE,
  run_reweighting = FALSE,
  run_jackknife = TRUE,
  run_leadlag = FALSE,
  run_common_factor = FALSE,
  sensitivity_analysis = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{results_robust}{Output from run_complete_factor_analysis_robust()}

\item{X_matrix}{Matrix of first set of variables}

\item{Y_matrix}{Matrix of second set of variables}

\item{path_cpi}{Path to CPI data (default: NULL)}

\item{path_weights}{Path to weights data (default: NULL)}

\item{sector_names}{Vector of sector names (default: NULL)}

\item{run_permutation}{Logical, run permutation test (default: TRUE)}

\item{run_reweighting}{Logical, run reweighting test (default: FALSE)}

\item{run_jackknife}{Logical, run jackknife test (default: TRUE)}

\item{run_leadlag}{Logical, run lead-lag test (default: FALSE)}

\item{run_common_factor}{Logical, run common factor test (default: FALSE)}

\item{sensitivity_analysis}{Logical, run sensitivity analysis (default: TRUE)}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
List with components:
\describe{
\item{\code{permutation}}{Results from permutation test.}
\item{\code{reweighting}}{Results from reweighting test (if applicable).}
\item{\code{jackknife}}{Results from jackknife test (if requested).}
\item{\code{summary}}{Data frame summarizing all tests.}
\item{\code{overall_robust}}{Logical indicating if convergence is robust across all tests.}
}
}
\description{
Executes all available robustness tests (permutation, reweighting, jackknife)
and synthesizes results into an integrated assessment.
}
