% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_ref.R
\name{correct_ref}
\alias{correct_ref}
\title{Correct and Standardize References in a 'Word' Document}
\usage{
correct_ref(input_path, output_path, reference_lines = 50, style = "vancouver")
}
\arguments{
\item{input_path}{Character string specifying the path to the input 'Word'
(.docx) document containing incomplete references.}

\item{output_path}{Character string specifying the path where the corrected
'Word' document will be written.}

\item{reference_lines}{Integer specifying the number of lines at the end of
the document that are treated as references.}

\item{style}{Character string specifying the reference style (e.g.,
\code{"vancouver"}).}
}
\value{
Writes a corrected 'Word' document to the location specified by
\code{output_path}. The function returns \code{invisible(NULL)}.
}
\description{
Reads a 'Word' document containing bibliographic references with missing or
incomplete information (e.g., authors, title, year, volume, issue, or page
numbers) and produces an updated document with standardized and completed
references. Missing metadata are retrieved using the 'CrossRef' application
programming interface (API), and digital object identifiers (DOIs) are added
where available.
}
\examples{
\donttest{
library(officer)

# Step 1: Create a temporary Word document with sample references
tmp_input <- file.path(tempdir(), "tmp_refs.docx")
doc <- read_docx()
doc <- body_add_par(doc, "1. Smith J. Some article. 2020;10(2):123-9.", style = "Normal")
doc <- body_add_par(doc, "2. Doe A. Another article. 2021;5(1):10-5.", style = "Normal")
print(doc, target = tmp_input)

# Step 2: Specify output path
tmp_output <- file.path(tempdir(), "updated_refs.docx")

# Step 3: Run the reference correction function
correct_ref(
  input_path = tmp_input,
  output_path = tmp_output,
  reference_lines = 2,
  style = "vancouver"
)

# Step 4: The corrected Word file is saved in tmp_output
tmp_output
}
}
