# tests/testthat/test-keyboard.R

test_that("qwerty_distance calculates correctly", {
  # Same key = 0
  expect_equal(qwerty_distance("a", "a"), 0)
  # Adjacent keys = 1
  expect_equal(qwerty_distance("a", "s"), 1)
  # Diagonal = sqrt(2)
  expect_equal(qwerty_distance("q", "s"), sqrt(2), tolerance = 0.01)
})

test_that("qwerty_adjacent returns neighbors", {
  adj <- qwerty_adjacent("f")
  expect_true("d" %in% adj)
  expect_true("g" %in% adj)
  expect_true("r" %in% adj)
  expect_false("z" %in% adj)
})

test_that("adjacent_key_typo produces valid typo", {
  set.seed(123)
  result <- adjacent_key_typo("test")
  expect_type(result, "character")
  expect_equal(nchar(result), nchar("test"))
  # At least one character should differ
  expect_false(result == "test")
})

test_that("keyboard_mash produces random string", {
  set.seed(456)
  result <- keyboard_mash("hello", n_extra = 3)
  expect_type(result, "character")
  # Should be longer than original
  expect_true(nchar(result) > nchar("hello"))
})

test_that("is_keyboard_adjacent detects adjacency", {
  expect_true(is_keyboard_adjacent("a", "s"))
  expect_true(is_keyboard_adjacent("f", "g"))
  expect_false(is_keyboard_adjacent("a", "p"))
})
