% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unvendor.R
\name{unvendor}
\alias{unvendor}
\title{Unvendor the cpp4r headers}
\usage{
unvendor(path = NULL)
}
\arguments{
\item{path}{The directory with the vendored headers. It is recommended to use \code{"./src/vendor"}.
The default is \code{NULL}.}
}
\value{
The path to the unvendored code (invisibly).
}
\description{
This function removes the vendored cpp4r headers from your package by
automatically finding the vendored headers.
}
\examples{
# create a new directory
dir <- paste0(tempdir(), "/", gsub("\\\\s+|[[:punct:]]", "", Sys.time()))
dir.create(dir, recursive = TRUE)

# vendor the cpp4r headers into the directory
vendor(dir)

# unvendor the cpp4r headers from the directory
unvendor(dir)

# cleanup
unlink(dir, recursive = TRUE)
}
