% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unordered_map.R
\name{cpp_unordered_map}
\alias{cpp_unordered_map}
\title{Create unordered map}
\usage{
cpp_unordered_map(keys, values)
}
\arguments{
\item{keys}{An integer, numeric, character, or logical vector.}

\item{values}{An integer, numeric, character, or logical vector.}
}
\value{
Returns a CppUnorderedMap object referencing an unordered_map in C++.
}
\description{
Create an unordered map. Unordered maps are key-value pairs with unique keys.
}
\details{
Unordered maps are associative containers. They do not provide random access through an index. I.e. \code{m[2]} does not return the second 
element.

Unordered means that the container does not enforce elements to be stored in a particular order. This makes unordered maps in some applications faster 
than maps.

C++ unordered_map methods implemented in this package are \link{at}, \link{bucket_count}, \link{clear}, \link{contains}, \link{count}, \link{emplace}, 
\link{empty}, \link{erase}, \link{insert}, \link{insert_or_assign}, \link{load_factor}, \link{max_bucket_count}, \link{max_load_factor}, 
\link{max_size}, \link{merge}, \link{rehash}, \link{reserve}, \link{size}, and \link{try_emplace}. The package also adds the \link{==} and \link{[} 
operators and various helper functions (\link{print}, \link{to_r}, \link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
m <- cpp_unordered_map(4:6, seq.int(1, by = 0.5, length.out = 3L))
m
# [6,2] [5,1.5] [4,1]

insert(m, seq.int(100, by = 0.1, length.out = 3L), 14:16)
m
# [16,100.2] [15,100.1] [14,100] [6,2] [5,1.5] [4,1]

print(m, n = 3)
# [16,100.2] [15,100.1] [14,100]

m <- cpp_unordered_map(c("world", "hello", "there"), 4:6)
m
# ["there",6] ["hello",5] ["world",4]

erase(m, "there")
m
# ["hello",5] ["world",4]

}
\seealso{
\link{cpp_map}, \link{cpp_multimap}, \link{cpp_unordered_multimap}.
}
