% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emplace.R
\name{emplace}
\alias{emplace}
\alias{emplace,CppSet-method}
\alias{emplace,CppUnorderedSet-method}
\alias{emplace,CppMultiset-method}
\alias{emplace,CppUnorderedMultiset-method}
\alias{emplace,CppMap-method}
\alias{emplace,CppUnorderedMap-method}
\alias{emplace,CppMultimap-method}
\alias{emplace,CppUnorderedMultimap-method}
\alias{emplace,CppStack-method}
\alias{emplace,CppQueue-method}
\alias{emplace,CppPriorityQueue-method}
\alias{emplace,CppVector-method}
\alias{emplace,CppDeque-method}
\alias{emplace,CppList-method}
\title{Add an element}
\usage{
emplace(x, value, key = NULL, position = NULL)
}
\arguments{
\item{x}{A CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppMap, CppUnorderedMap, CppMultimap, CppUnorderedMultimap, CppStack, CppQueue, 
CppPriorityQueue, CppVector, CppDeque, or CppList object.}

\item{value}{A value to add to \code{x}.}

\item{key}{A key to add to \code{x}. Only relevant for CppMap, CppUnorderedMap, CppMultimap, and CppUnorderedMultimap objects.}

\item{position}{The index at which to add the element. Only relevant for CppVector, CppDeque, and CppList objects. Indices start at 1.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Add an element to a container by reference in place.
}
\details{
Existing container values are not overwritten. I.e. inserting a key-value pair into a map that already contains that key preserves the old 
value and discards the new one. Use \link{insert_or_assign} to overwrite values.

\code{emplace} and \link{try_emplace} produce the same results in the context of this package. \link{try_emplace} can be minimally more computationally 
efficient than \code{emplace}.

The emplace methods only add single elements. Use \link{insert} to add multiple elements in one call.
}
\examples{
s <- cpp_set(c(1.5, 2.3, 4.1))
s
# 1.5 2.3 4.1

emplace(s, 3.1)
s
# 1.5 2.3 3.1 4.1

m <- cpp_unordered_map(c("hello", "there"), c(TRUE, FALSE))
m
# ["there",FALSE] ["hello",TRUE]

emplace(m, TRUE, "world")
m
# ["world",TRUE] ["there",FALSE] ["hello",TRUE]

d <- cpp_deque(4:6)
d
# 4 5 6

emplace(d, 9, position = 2)
d
# 4 9 5 6

}
\seealso{
\link{assign}, \link{emplace_after}, \link{emplace_back}, \link{emplace_front}, \link{insert}, \link{try_emplace}.
}
