% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrink_to_fit.R
\name{shrink_to_fit}
\alias{shrink_to_fit}
\alias{shrink_to_fit,CppVector-method}
\alias{shrink_to_fit,CppDeque-method}
\title{Shrink container capacity to size}
\usage{
shrink_to_fit(x)
}
\arguments{
\item{x}{A CppVector or CppDeque object.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Shrink the capacity of a container to its size by reference.
}
\details{
The capacity is the space, in terms of the number of elements, reserved for a container. The size is the number of elements in the container.
}
\examples{
v <- cpp_vector(4:6)
capacity(v)
# [1] 3

reserve(v, 10)
capacity(v)
# [1] 10

shrink_to_fit(v)
capacity(v)
# [1] 3

}
\seealso{
\link{capacity}, \link{reserve}, \link{size}.
}
