% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_km_utils.R
\name{df2gg}
\alias{df2gg}
\title{Convert Data Frame to ggplot2 Table Graphic}
\usage{
df2gg(
  df,
  colwidths = NULL,
  font_size = 10,
  col_labels = TRUE,
  col_lab_fontface = "bold",
  hline = TRUE,
  bg_fill = NULL,
  add_proper_xaxis = FALSE
)
}
\arguments{
\item{df}{The data frame to render.}

\item{colwidths}{Numeric vector of relative column widths. If \code{NULL}, determined by max character length.}

\item{font_size}{Numeric base font size.}

\item{col_labels}{Logical, whether to display column labels (header).}

\item{col_lab_fontface}{Character string for the font face of column labels (e.g., "bold").}

\item{hline}{Logical, whether to draw a horizontal line below the column labels.}

\item{bg_fill}{Optional color string for the plot background.}

\item{add_proper_xaxis}{Logical, whether to add a proper x-axis with column values.}
}
\value{
A \code{ggplot2} object representing the table.
}
\description{
Creates a \code{ggplot2} object that renders a data frame as a table graphic.
}
\keyword{internal}
