% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcf.R
\name{build_lease_table}
\alias{build_lease_table}
\title{Stylised rent table (lease cash-flow)}
\usage{
build_lease_table(rent_signed, surface_m2, n_years, vac_rate_vec = 0)
}
\arguments{
\item{rent_signed}{numeric. Face rent (€/m²/year) (scalar or vector).}

\item{surface_m2}{numeric. Floor area (m²) (scalar or vector).}

\item{n_years}{integer(1). Number of years.}

\item{vac_rate_vec}{numeric. Vacancy (scalar or vector), recycled to \code{n_years}.}
}
\value{
\code{tibble(year, noi)}.
}
\description{
Builds a minimal \code{year}-\code{noi} table for \code{n_years}
with optionally vectorised vacancy rates.
}
\examples{
build_lease_table(400, 2500, n_years = 5, vac_rate_vec = c(0, .05, .1))
}
