% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{run_case}
\alias{run_case}
\title{Run a full DCF case from a list or a YAML file}
\usage{
run_case(
  config = NULL,
  config_file = NULL,
  debt_type = c("bullet", "amort"),
  ltv_base = c("price_di", "price_ht", "value")
)
}
\arguments{
\item{config}{Optional list configuration following the YAML grammar.}

\item{config_file}{Optional path to a YAML configuration file. If both
\code{config} and \code{config_file} are \code{NULL}, defaults to the package
example at \code{inst/extdata/config.yml}.}

\item{debt_type}{Debt schedule type to use (\code{"bullet"} or \code{"amort"}).
This parameter overrides any implicit type inferred in normalization.}

\item{ltv_base}{Base for loan-to-value (LTV) and initial principal. One of
\code{"price_di"}, \code{"price_ht"}, or \code{"value"}.}
}
\value{
A list containing pricing (acquisition price net of taxes, acquisition costs,
and acquisition price including costs), all-equity metrics, leveraged metrics,
a comparison table, the full cash-flow table with credit ratios, and selected
configuration flags.
}
\description{
User-facing single entry point. Accepts either an in-memory \code{config} list
or a \code{config_file} path to YAML. Both routes share the same validation
and normalization pathway, ensuring identical downstream behavior.
}
\details{
The function centralizes user ergonomics:
\itemize{
\item Reads either a list or a YAML file.
\item Validates and normalizes with \code{cfg_validate()} and \code{cfg_normalize()}.
\item Computes the unlevered discounted cash flow (DCF), builds a debt schedule,
computes leveraged metrics, and adds credit ratios to the full cash-flow table.
\item Handles capitalized arrangement fees by adjusting the scheduled principal
to avoid double-counting.
}
}
\examples{
# R list route
cfg <- dcf_spec_template()
cfg$leases <- list(
  list(
    unit = "U",
    area = 1000,
    events = list(
      list(
        start = cfg$purchase_year,
        end   = cfg$purchase_year + cfg$horizon_years,  # keep NOI positive in terminal year
        rent = 200,
        free_months = 0,
        capex_sqm = 0,
        vac = 0,
        new_lease = 0
      )
    )
  )
)
out <- run_case(config = cfg, debt_type = "bullet")
names(out)
}
