% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backfill-class.R
\docType{class}
\name{OpeningAny-class}
\alias{OpeningAny-class}
\alias{.OpeningAny}
\alias{OpeningAny}
\alias{.DefaultOpeningAny}
\title{\code{OpeningAny}}
\usage{
OpeningAny(...)

.DefaultOpeningAny()
}
\arguments{
\item{...}{(\code{Opening})
opening objects to combine with OR logic.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{OpeningAny}} combines multiple \code{\link{Opening}} objects using OR logic.
A backfill cohort is opened if ANY opening criteria in the list
are satisfied. This can also be created using the \code{|} operator.
}
\section{Slots}{

\describe{
\item{\code{open_list}}{(\code{list})\cr a list of \code{\link{Opening}} objects to be
combined with OR logic.}
}}

\note{
Typically, end users will not use the \code{.DefaultOpeningAny()} function.
}
\examples{
# Create two opening criteria
opening1 <- OpeningMinDose(min_dose = 10)
opening2 <- OpeningMinCohorts(min_cohorts = 3)

# Combine them with OR logic: at least one must be satisfied
opening_any <- OpeningAny(opening1, opening2)
print(opening_any)

# Alternative: use the | operator
opening_any_alt <- opening1 | opening2
print(opening_any_alt)
}
\seealso{
\code{\link{Opening}}, \code{\link{OpeningAll}}, \code{\link{OpeningList}}.
}
