% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{h_in_range}
\alias{h_in_range}
\title{Check which elements are in a given range}
\usage{
h_in_range(x, range = c(0, 1), bounds_closed = TRUE)
}
\arguments{
\item{x}{(\code{numeric})\cr vector or matrix with elements to test.}

\item{range}{(\code{numeric})\cr an interval, i.e. sorted two-elements vector.}

\item{bounds_closed}{(\code{logical})\cr should bounds in the \code{range} be treated
as closed? This can be a scalar or vector of length two. If it is a scalar,
then its value applies to lower bound \code{range[1]} and upper bound
\code{range[2]}. If this is a vector with two flags, the first flag corresponds
to the lower bound only, and the second to the upper bound only.}
}
\value{
A logical vector or matrix of length equal to the length of \code{x}, that
for every element of \code{x}, indicates whether a given element of \code{x} is in
the \code{range}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A simple helper function that tests whether elements of a given vector or
matrix are within specified interval.
}
\examples{
x <- 1:4
h_in_range(x, range = c(1, 3))
h_in_range(x, range = c(1, 3), bounds_closed = FALSE)
h_in_range(x, range = c(1, 3), bounds_closed = c(FALSE, TRUE))
mat <- matrix(c(2, 5, 3, 10, 4, 9, 1, 8, 7), nrow = 3)
h_in_range(mat, range = c(1, 5))
}
